#ifndef SST_HOST_TST_MESSAGE_H
#define SST_HOST_TST_MESSAGE_H



/************************ Includes *****************************/
#include "DX_VOS_BaseTypes.h"
#include "sst_types.h"
#include "ExtApp_qa_op_code.h"

#ifdef __cplusplus
extern "C"
{
#endif


/*********************** Public Functions **********************/


/********************************************************************************
* Function Name:                                                           
*  HOSTQA_ATP_Message         
* 
* Inputs:
*  Host_opCode[in]           - OpCode of external application function on the SEP.
*  EXT_DataStructSize[in]    - Size of data struct of external application function on the SEP.
*  testData[in]              - pointer to data.
*
* Outputs:
*  DxUint32 - On success DX_OK is returned                                       
*                                                                 
* 
* Description:                                                                 
*  This function is used to operate the qa external application on the SEP, 
*  that executes appropriate ATP test according to Host OPCODE.
*
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with data 
* 3. write the message to shared memory                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*/
/******************************************************************************/   

IMPORT_C DxUint32 HOSTQA_ATP_Message(DxUint32_t Host_opCode,DxUint32_t EXT_DataStructSize,void* testData);


#ifdef __cplusplus
}
#endif

#endif
